<?php
$base    = '/ramblerco';
$current = basename($_SERVER['PHP_SELF'], '.php');
?><!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="description" content="<?= $meta_desc ?? 'Rambler Qatar — Premium Corporate Gifts, Promotional Products & Branded Merchandise in Doha, Qatar. 6000+ products, 2500+ global clients.' ?>">
  <title><?= $page_title ?? 'Rambler Qatar — Premium Corporate Gifts & Branded Merchandise' ?></title>

  <!-- Tailwind CSS -->
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    tailwind.config = {
      theme: {
        extend: {
          fontFamily: {
            sans:    ['Inter','system-ui','sans-serif'],
            display: ['Plus Jakarta Sans','Inter','sans-serif'],
          }
        }
      }
    }
  </script>

  <!-- Google Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,300;0,14..32,400;0,14..32,500;0,14..32,600;0,14..32,700;1,14..32,400&family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">

  <!-- GSAP + ScrollTrigger -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/gsap.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.5/ScrollTrigger.min.js"></script>

  <!-- Lenis Smooth Scroll -->
  <script src="https://cdn.jsdelivr.net/npm/@studio-freight/lenis@1.0.42/bundled/lenis.min.js"></script>

  <!-- VanillaTilt (3D card hover) -->
  <script src="https://unpkg.com/vanilla-tilt@1.8.1/dist/vanilla-tilt.min.js"></script>

  <!-- Alpine.js -->
  <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

  <!-- Custom CSS -->
  <link rel="stylesheet" href="<?= $base ?>/assets/css/style.css">
</head>
<body class="font-sans antialiased overflow-x-hidden" style="background:#F6F3EE;color:#3A3745;" x-data="{ mobileOpen: false }">

<!-- Preloader -->
<div id="preloader">
  <div class="flex flex-col items-center gap-5">
    <img src="<?= $base ?>/logo (2).png" alt="Rambler" class="h-10 opacity-90">
    <div class="loader-ring"></div>
  </div>
</div>

<!-- Custom Cursor (desktop) -->
<div id="cursor"></div>
<div id="cursor-follower"></div>

<!-- ── Navigation — Light Theme ── -->
<nav id="navbar" class="fixed top-0 left-0 right-0 z-[100]">
  <div class="container-xl">
    <div class="flex items-center justify-between h-20">

      <!-- Logo — shows naturally on light bg, no filter needed -->
      <a href="<?= $base ?>/index.php" class="flex-shrink-0 flex items-center">
        <img src="<?= $base ?>/logo (2).png"
             alt="Rambler Qatar"
             class="nav-logo h-10 w-auto">
      </a>

      <!-- Desktop Links — dark text -->
      <div class="hidden lg:flex items-center gap-8">
        <?php
        $navItems = [
          ['Home',       "$base/index.php",          ['index']],
          ['Catalogues', "$base/catalog.php",         ['catalog','catalog-detail','catalog-viewer']],
          ['Products',   "$base/index.php#products",  []],
          ['About',      "$base/index.php#about",     []],
          ['Contact',    "$base/index.php#contact",   []],
        ];
        foreach ($navItems as [$label, $href, $active_on]):
          $isActive = in_array($current, $active_on);
          $activeClass = $isActive ? 'active' : '';
        ?>
        <a href="<?= $href ?>"
           class="nav-link text-sm font-semibold tracking-wide transition-colors duration-200 <?= $activeClass ?>"
           style="color:<?= $isActive ? '#C42830' : '#3A3745' ?>;">
          <?= $label ?>
        </a>
        <?php endforeach; ?>
      </div>

      <!-- Right CTA -->
      <div class="flex items-center gap-3">
        <a href="tel:+97470993232"
           class="hidden lg:flex items-center gap-2 text-sm font-medium transition-colors"
           style="color:#7A7788;"
           onmouseover="this.style.color='#C42830'" onmouseout="this.style.color='#7A7788'">
          <svg class="w-3.5 h-3.5" style="color:#C42830;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
          </svg>
          +974 7099 3232
        </a>
        <a href="<?= $base ?>/index.php#contact"
           class="hidden lg:inline-flex btn-primary px-5 py-2.5 rounded-full text-sm">
          Get a Quote
          <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
          </svg>
        </a>

        <!-- Hamburger — dark bars for light bg -->
        <button @click="mobileOpen = !mobileOpen"
                class="lg:hidden w-10 h-10 flex flex-col items-center justify-center gap-[6px] rounded-xl transition-colors"
                style="border:1.5px solid rgba(0,0,0,0.12);">
          <span class="block w-5 h-px transition-all duration-300"
                style="background:#3A3745;"
                :class="mobileOpen ? 'rotate-45 translate-y-[7px]' : ''"></span>
          <span class="block w-5 h-px transition-all duration-300"
                style="background:#3A3745;"
                :class="mobileOpen ? 'opacity-0' : ''"></span>
          <span class="block w-5 h-px transition-all duration-300"
                style="background:#3A3745;"
                :class="mobileOpen ? '-rotate-45 -translate-y-[7px]' : ''"></span>
        </button>
      </div>
    </div>
  </div>

  <!-- Mobile Menu — light -->
  <div x-show="mobileOpen"
       x-transition:enter="transition ease-out duration-200"
       x-transition:enter-start="opacity-0 -translate-y-2"
       x-transition:enter-end="opacity-100 translate-y-0"
       x-transition:leave="transition ease-in duration-150"
       x-transition:leave-start="opacity-100 translate-y-0"
       x-transition:leave-end="opacity-0 -translate-y-2"
       style="border-top:1px solid rgba(0,0,0,0.07);background:rgba(246,243,238,0.98);backdrop-filter:blur(20px);"
       class="lg:hidden">
    <div class="container-xl py-6 flex flex-col gap-1">
      <?php
      $mob = [
        ['Home',       "$base/index.php"],
        ['Catalogues', "$base/catalog.php"],
        ['Products',   "$base/index.php#products"],
        ['About',      "$base/index.php#about"],
        ['Contact',    "$base/index.php#contact"],
      ];
      foreach ($mob as [$label, $href]): ?>
      <a href="<?= $href ?>" @click="mobileOpen=false"
         class="px-4 py-3 rounded-xl font-medium transition-all text-sm"
         style="color:#3A3745;"
         onmouseover="this.style.background='rgba(196,40,48,0.07)';this.style.color='#C42830';"
         onmouseout="this.style.background='transparent';this.style.color='#3A3745';">
        <?= $label ?>
      </a>
      <?php endforeach; ?>
      <a href="<?= $base ?>/index.php#contact" @click="mobileOpen=false"
         class="btn-primary mt-3 px-6 py-3 rounded-full text-sm text-center justify-center">
        Get a Quote
      </a>
    </div>
  </div>
</nav>
