<?php
$page_title = 'Catalogues — Rambler Qatar | Download Our 2026 Product PDFs';
$meta_desc  = 'Download Rambler Qatar\'s 2026 product catalogues. Corporate gifts, clothing, electronics, eco products, luxury gifts and more. Free PDF download.';
$base       = '/ramblerco';

$cats_json = file_get_contents(__DIR__ . '/data/catalogs.json');
$data      = json_decode($cats_json, true);
$all_cats  = $data['catalogs'];

$active_filter = isset($_GET['cat']) ? htmlspecialchars($_GET['cat']) : 'all';
$categories    = array_unique(array_column($all_cats, 'category'));

include __DIR__ . '/includes/header.php';
?>

<!-- ═══════════════════════════════════════════
     PAGE HERO
════════════════════════════════════════════ -->
<section class="page-hero" style="padding-bottom:60px;background:#F6F3EE;">
  <div class="page-hero-bg"></div>
  <!-- Aurora mini (light) -->
  <div style="position:absolute;inset:0;overflow:hidden;pointer-events:none;">
    <div style="position:absolute;width:40vw;height:40vw;border-radius:50%;filter:blur(100px);background:radial-gradient(circle,rgba(196,40,48,.08),transparent 70%);top:-10%;right:-5%;"></div>
    <div style="position:absolute;width:30vw;height:30vw;border-radius:50%;filter:blur(90px);background:radial-gradient(circle,rgba(28,46,112,.07),transparent 70%);bottom:-10%;left:5%;"></div>
  </div>
  <div class="noise-overlay"></div>
  <div class="container-xl relative z-10">
    <!-- Breadcrumb -->
    <div class="flex items-center gap-2 text-xs mb-8" style="color:#ADAAB8;">
      <a href="<?= $base ?>/index.php" class="transition-colors hover:text-[#C42830]" style="color:#7A7788;">Home</a>
      <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
      <span style="color:#3A3745;">Catalogues</span>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
      <div>
        <div class="section-badge mb-6"><span class="dot"></span>2026 Edition</div>
        <h1 class="text-5xl md:text-6xl font-display font-bold mb-5 leading-[.95]" style="color:#0E0B16;">
          Download Our<br>
          <span class="gradient-text">Product Catalogues</span>
        </h1>
        <p class="text-base leading-relaxed max-w-lg" style="color:#7A7788;">
          <?= count($all_cats) ?> premium catalogues. 6,000+ products.
          View online or download PDF — fully brandable with your logo and identity.
        </p>
        <!-- Quick stats row -->
        <div class="flex flex-wrap gap-6 mt-8 pt-8" style="border-top:1px solid rgba(0,0,0,0.07);">
          <?php foreach ([['6,000+','Products'],[count($all_cats),'Catalogues'],['Free','PDF Download'],['24h','Quote Response']] as $s): ?>
          <div>
            <div class="text-xl font-bold font-display" style="color:#C42830;"><?= $s[0] ?></div>
            <div class="text-xs mt-0.5" style="color:#ADAAB8;"><?= $s[1] ?></div>
          </div>
          <?php endforeach; ?>
        </div>
      </div>
      <!-- Mini book stack visual -->
      <div class="hidden lg:flex items-end justify-center gap-4 pb-4">
        <?php foreach (array_slice($all_cats, 0, 4) as $i => $c): ?>
        <a href="<?= $base ?>/catalog-viewer.php?id=<?= $c['id'] ?>"
           class="pdf-book-wrapper flex-shrink-0"
           style="width:<?= [90,100,110,95][$i] ?>px; transform:translateY(<?= [20,8,0,15][$i] ?>px) rotate(<?= [-4,-1,2,-3][$i] ?>deg);">
          <div class="pdf-book" style="box-shadow:8px 16px 40px rgba(0,0,0,.6);">
            <div class="pdf-book-cover">
              <div style="padding-bottom:138%;position:relative;background:linear-gradient(135deg,<?= $c['gradient_from'] ?>,<?= $c['gradient_to'] ?>);border-radius:4px 10px 10px 4px;overflow:hidden;">
                <div style="position:absolute;inset:0;opacity:.07;background-image:radial-gradient(circle at 1px 1px,rgba(255,255,255,.6) 1px,transparent 0);background-size:14px 14px;"></div>
                <div style="position:absolute;bottom:10px;left:10px;right:10px;">
                  <div style="font-size:8px;font-weight:800;color:rgba(255,255,255,.9);text-transform:uppercase;letter-spacing:.05em;line-height:1.2;"><?= htmlspecialchars($c['title']) ?></div>
                  <div style="font-size:7px;color:rgba(255,255,255,.4);margin-top:3px;"><?= $c['year'] ?></div>
                </div>
                <div style="position:absolute;top:8px;right:8px;font-size:28px;font-weight:900;color:rgba(255,255,255,.07);font-family:'Plus Jakarta Sans',sans-serif;"><?= str_pad($c['id'],2,'0',STR_PAD_LEFT) ?></div>
                <div class="book-shine-overlay"></div>
              </div>
            </div>
            <div class="pdf-book-pages"></div>
          </div>
        </a>
        <?php endforeach; ?>
      </div>
    </div>
  </div>
</section>

<!-- ═══════════════════════════════════════════
     FILTER TABS
════════════════════════════════════════════ -->
<div class="sticky top-[80px] z-50" style="background:rgba(246,243,238,0.96);backdrop-filter:blur(20px);border-bottom:1px solid rgba(0,0,0,0.07);box-shadow:0 4px 16px rgba(0,0,0,0.04);">
  <div class="container-xl py-4">
    <div class="flex flex-wrap gap-2.5 items-center">
      <span style="font-size:11px;font-weight:600;letter-spacing:.1em;text-transform:uppercase;color:#ADAAB8;" class="mr-1 hidden sm:inline">Filter:</span>

      <button data-filter="all"
              class="filter-tab active"
              onclick="filterCatalogs(this,'all')">
        All <span style="color:#ADAAB8;" class="ml-1">(<?= count($all_cats) ?>)</span>
      </button>
      <?php foreach ($categories as $cat):
        $cnt = count(array_filter($all_cats, fn($c) => $c['category'] === $cat));
      ?>
      <button data-filter="<?= htmlspecialchars($cat) ?>"
              class="filter-tab"
              onclick="filterCatalogs(this,'<?= htmlspecialchars($cat) ?>')">
        <?= htmlspecialchars($cat) ?>
        <span style="color:#ADAAB8;" class="ml-1">(<?= $cnt ?>)</span>
      </button>
      <?php endforeach; ?>

      <div class="ml-auto hidden md:flex items-center gap-2" style="font-size:12px;color:#ADAAB8;">
        <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10M12 21v-4M12 17l-4-4m4 4l4-4M5 3h14a2 2 0 012 2v8a2 2 0 01-2 2H5a2 2 0 01-2-2V5a2 2 0 012-2z"/>
        </svg>
        Free PDF downloads available
      </div>
    </div>
  </div>
</div>

<!-- ═══════════════════════════════════════════
     FEATURED CATALOG — Large hero card
════════════════════════════════════════════ -->
<?php $feat = array_values(array_filter($all_cats, fn($c) => $c['featured']))[0] ?? $all_cats[0]; ?>
<section class="section-spacing pb-0" id="catalogs-section">
  <div class="container-xl">

    <div class="section-badge mb-8 reveal"><span class="dot"></span>Featured Catalogue</div>

    <!-- Featured large card -->
    <div class="catalog-featured reveal" data-category="<?= htmlspecialchars($feat['category']) ?>" style="--feat-col:<?= $feat['accent'] ?>;">

      <!-- 3D Book -->
      <div class="pdf-book-wrapper" style="width:280px;">
        <div class="pdf-book" style="box-shadow:20px 32px 80px rgba(0,0,0,.7);">
          <div class="pdf-book-cover">
            <div class="pdf-cover-inner"
                 style="background:linear-gradient(135deg,<?= $feat['gradient_from'] ?>,<?= $feat['gradient_to'] ?>);">
              <div class="pdf-cover-pattern"></div>
              <div class="pdf-cover-diagonal"></div>
              <div class="pdf-cover-content">
                <!-- Top bar -->
                <div>
                  <div style="display:flex;align-items:center;gap:6px;margin-bottom:12px;">
                    <div style="width:24px;height:2px;background:<?= $feat['accent'] ?>;border-radius:2px;"></div>
                    <span style="font-size:9px;font-weight:700;color:<?= $feat['accent'] ?>;letter-spacing:.12em;text-transform:uppercase;">
                      <?= $feat['category'] ?>
                    </span>
                  </div>
                  <div style="font-size:9px;color:rgba(255,255,255,.35);letter-spacing:.1em;">RAMBLER QATAR</div>
                </div>
                <!-- Middle: number -->
                <div style="font-size:80px;font-weight:900;line-height:1;color:rgba(255,255,255,.06);font-family:'Plus Jakarta Sans',sans-serif;text-align:right;margin-top:auto;">
                  <?= str_pad($feat['id'],2,'0',STR_PAD_LEFT) ?>
                </div>
                <!-- Bottom -->
                <div>
                  <div style="font-size:13px;font-weight:800;color:#fff;line-height:1.2;margin-bottom:6px;font-family:'Plus Jakarta Sans',sans-serif;">
                    <?= htmlspecialchars($feat['title']) ?>
                  </div>
                  <div style="display:flex;align-items:center;justify-content:space-between;">
                    <span style="font-size:9px;color:rgba(255,255,255,.4);"><?= $feat['pages'] ?> pages</span>
                    <span style="font-size:9px;font-weight:700;color:<?= $feat['accent'] ?>;"><?= $feat['year'] ?></span>
                  </div>
                </div>
              </div>
              <div class="book-shine-overlay"></div>
            </div>
          </div>
          <div class="pdf-book-spine"></div>
          <div class="pdf-book-pages"></div>
        </div>
      </div>

      <!-- Info -->
      <div>
        <div class="flex flex-wrap gap-2 mb-5">
          <span class="section-badge" style="background:<?= $feat['accent'] ?>18;border-color:<?= $feat['accent'] ?>33;color:<?= $feat['accent'] ?>;">
            <span class="dot" style="background:<?= $feat['accent'] ?>;"></span>
            Featured 2026
          </span>
          <?php foreach ($feat['tags'] as $tag): ?>
          <span style="display:inline-flex;align-items:center;padding:4px 12px;background:rgba(0,0,0,.04);border:1px solid rgba(0,0,0,.08);border-radius:100px;font-size:11px;font-weight:500;color:#7A7788;">
            <?= htmlspecialchars($tag) ?>
          </span>
          <?php endforeach; ?>
        </div>

        <h2 class="text-3xl md:text-4xl font-display font-bold mb-4 leading-tight" style="color:#0E0B16;">
          <?= htmlspecialchars($feat['title']) ?>
        </h2>
        <p class="text-sm leading-relaxed mb-6 max-w-lg" style="color:#7A7788;">
          <?= htmlspecialchars($feat['description']) ?>
        </p>

        <!-- Stats row -->
        <div class="flex flex-wrap gap-6 mb-8 pb-8" style="border-bottom:1px solid rgba(0,0,0,.07);">
          <?php foreach ([[$feat['products_count'].'+','Products'],[$feat['pages'],'Pages'],['Free','Download'],['24h','Quote']] as $s): ?>
          <div>
            <div class="text-2xl font-bold font-display" style="color:<?= $feat['accent'] ?>;"><?= $s[0] ?></div>
            <div class="text-xs mt-0.5" style="color:#ADAAB8;"><?= $s[1] ?></div>
          </div>
          <?php endforeach; ?>
        </div>

        <!-- Actions -->
        <div class="flex flex-wrap gap-3">
          <a href="<?= $base ?>/catalog-viewer.php?id=<?= $feat['id'] ?>"
             class="btn-primary px-6 py-3 rounded-xl text-sm">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
            </svg>
            View Flipbook
          </a>
          <a href="<?= $base ?>/catalog-detail.php?id=<?= $feat['id'] ?>"
             class="btn-ghost px-6 py-3 rounded-xl text-sm">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 10h16M4 14h16M4 18h16"/>
            </svg>
            Browse Products
          </a>
          <a href="<?= $base ?>/<?= $feat['pdf_url'] ?>"
             target="_blank" rel="noopener"
             class="btn-ghost px-6 py-3 rounded-xl text-sm"
             style="border-color:<?= $feat['accent'] ?>55;color:<?= $feat['accent'] ?>;"
             onmouseover="this.style.background='<?= $feat['accent'] ?>18'"
             onmouseout="this.style.background=''">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"/>
            </svg>
            View PDF
          </a>
          <a href="<?= $base ?>/<?= $feat['pdf_url'] ?>"
             class="btn-ghost px-6 py-3 rounded-xl text-sm"
             download>
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
            </svg>
            Download PDF
          </a>
        </div>
      </div>
    </div>

    <!-- ── Luxury Brand Trust Strip ── -->
    <div class="my-14 reveal">
      <div class="flex items-center gap-5 py-4" style="border-top:1px solid rgba(0,0,0,0.06);border-bottom:1px solid rgba(0,0,0,0.06);">
        <span style="font-size:9px;font-weight:700;letter-spacing:.18em;color:#ADAAB8;text-transform:uppercase;white-space:nowrap;flex-shrink:0;">Brand Portfolio</span>
        <div style="height:14px;width:1px;background:rgba(0,0,0,0.08);flex-shrink:0;"></div>
        <div style="display:flex;align-items:center;gap:18px;overflow:hidden;flex:1;mask-image:linear-gradient(to right,transparent,black 8%,black 92%,transparent);">
          <?php
          $bl = ['Hugo Boss','Cacharel','Cerruti 1881','Christian Lacroix','Festina','LEXON','Pinetti','Prodir'];
          foreach (array_merge($bl,$bl) as $bi => $bn): ?>
          <span style="font-size:10px;font-weight:700;letter-spacing:.09em;color:<?= $bi%2===0?'#7A7788':'#ADAAB8' ?>;text-transform:uppercase;white-space:nowrap;flex-shrink:0;"><?= $bn ?></span>
          <span style="color:#C9A84C;font-size:7px;opacity:.55;flex-shrink:0;">◆</span>
          <?php endforeach; ?>
        </div>
      </div>
    </div>

    <!-- ── All Catalogues Grid ── -->
    <div class="mt-8 mb-4">
      <div class="flex items-center justify-between reveal">
        <div>
          <div class="flex items-center gap-3 mb-2">
            <div style="width:32px;height:2px;background:linear-gradient(to right,#C42830,#C9A84C);border-radius:2px;flex-shrink:0;"></div>
            <span style="font-size:10px;font-weight:700;letter-spacing:.14em;text-transform:uppercase;color:#ADAAB8;">Our Collection</span>
          </div>
          <h2 class="text-2xl md:text-3xl font-display font-bold" style="color:#0E0B16;">
            All <span class="gradient-text">Catalogues</span>
          </h2>
        </div>
        <span class="text-xs" style="color:#ADAAB8;" id="catalog-count"><?= count($all_cats) ?> catalogues</span>
      </div>
    </div>

    <!-- Grid of 3D book cards -->
    <div class="catalog-grid" id="catalog-grid">
      <?php foreach ($all_cats as $i => $cat): ?>
      <div class="pdf-card"
           data-category="<?= htmlspecialchars($cat['category']) ?>"
           style="opacity:0;">

        <?php
        $isRealPdf  = ($cat['viewer'] ?? '') === 'real-pdf';
        $viewerHref = $isRealPdf
          ? $base . '/catalog-pdf-viewer.php?id=' . $cat['id']
          : $base . '/catalog-viewer.php?id='     . $cat['id'];
        $viewerLabel = $isRealPdf ? 'View PDF' : 'Flipbook';
        ?>
        <!-- 3D Book -->
        <div class="pdf-book-wrapper" onclick="location.href='<?= $viewerHref ?>'"
             title="<?= $isRealPdf ? 'View Real PDF' : 'View Flipbook' ?> — <?= htmlspecialchars($cat['title']) ?>">
          <div class="pdf-book" style="box-shadow:12px 20px 60px rgba(0,0,0,.65);">
            <div class="pdf-book-cover">
              <?php if ($isRealPdf): ?>
              <!-- Real PDF: canvas cover (PDF.js renders page 1 lazily) -->
              <div style="padding-bottom:138%;position:relative;border-radius:4px 10px 10px 4px;overflow:hidden;background:linear-gradient(135deg,<?= $cat['gradient_from'] ?>,<?= $cat['gradient_to'] ?>);">
                <!-- Loading spinner -->
                <div class="real-cover-loader" data-id="<?= $cat['id'] ?>"
                     style="position:absolute;inset:0;display:flex;align-items:center;justify-content:center;transition:opacity .4s;">
                  <div style="text-align:center;">
                    <div style="width:22px;height:22px;border-radius:50%;border:2px solid rgba(255,255,255,.1);border-top-color:<?= $cat['accent'] ?>;animation:rcSpin .8s linear infinite;margin:0 auto 8px;"></div>
                    <div style="font-size:7px;color:rgba(255,255,255,.25);letter-spacing:.1em;font-family:'Plus Jakarta Sans',sans-serif;text-transform:uppercase;"><?= htmlspecialchars($cat['year']) ?></div>
                  </div>
                </div>
                <!-- Canvas filled by PDF.js -->
                <canvas class="real-pdf-cover-canvas"
                        data-pdf-url="<?= $base ?>/<?= $cat['pdf_url'] ?>"
                        data-loader-id="<?= $cat['id'] ?>"
                        style="position:absolute;inset:0;width:100%;height:100%;object-fit:cover;display:block;opacity:0;transition:opacity .5s;"></canvas>
                <div class="book-shine-overlay"></div>
              </div>
              <?php else: ?>
              <!-- Existing gradient cover -->
              <div class="pdf-cover-inner"
                   style="background:linear-gradient(145deg,<?= $cat['gradient_from'] ?>,<?= $cat['gradient_to'] ?>);">
                <div class="pdf-cover-pattern"></div>
                <div class="pdf-cover-diagonal"></div>
                <div class="pdf-cover-content">
                  <!-- Top -->
                  <div>
                    <div style="display:flex;align-items:center;gap:5px;margin-bottom:10px;">
                      <div style="width:18px;height:2px;background:<?= $cat['accent'] ?>;border-radius:2px;"></div>
                      <span style="font-size:8px;font-weight:700;color:<?= $cat['accent'] ?>;letter-spacing:.1em;text-transform:uppercase;">
                        <?= $cat['category'] ?>
                      </span>
                    </div>
                    <div style="font-size:7px;color:rgba(255,255,255,.3);letter-spacing:.1em;text-transform:uppercase;">
                      Rambler Qatar
                    </div>
                  </div>
                  <!-- Big number watermark -->
                  <div style="font-size:72px;font-weight:900;line-height:1;color:rgba(255,255,255,.05);font-family:'Plus Jakarta Sans',sans-serif;text-align:right;">
                    <?= str_pad($cat['id'],2,'0',STR_PAD_LEFT) ?>
                  </div>
                  <!-- Bottom -->
                  <div>
                    <div style="font-size:11px;font-weight:800;color:#fff;line-height:1.25;margin-bottom:8px;font-family:'Plus Jakarta Sans',sans-serif;">
                      <?= htmlspecialchars($cat['title']) ?>
                    </div>
                    <div style="display:flex;align-items:center;justify-content:space-between;">
                      <span style="font-size:8px;color:rgba(255,255,255,.35);"><?= $cat['pages'] ?> pages</span>
                      <span style="font-size:8px;font-weight:700;padding:2px 7px;border-radius:100px;background:<?= $cat['accent'] ?>33;color:<?= $cat['accent'] ?>;">
                        <?= $cat['year'] ?>
                      </span>
                    </div>
                    <div style="display:flex;flex-wrap:wrap;gap:3px;margin-top:8px;">
                      <?php foreach (array_slice($cat['tags'],0,2) as $tag): ?>
                      <span style="font-size:7px;padding:2px 6px;background:rgba(255,255,255,.08);border-radius:100px;color:rgba(255,255,255,.5);"><?= htmlspecialchars($tag) ?></span>
                      <?php endforeach; ?>
                    </div>
                  </div>
                </div>
              </div>
              <div class="book-shine-overlay"></div>
              <?php endif; ?>
            </div>
            <div class="pdf-book-spine"></div>
            <div class="pdf-book-pages"></div>
          </div>
        </div>

        <!-- Info below book -->
        <div class="mt-5">
          <h3 class="font-semibold text-sm leading-snug mb-1 hover:text-[#C42830] transition-colors cursor-pointer"
              style="color:#0E0B16;"
              onclick="location.href='<?= $base ?>/catalog-viewer.php?id=<?= $cat['id'] ?>'"
              title="View Flipbook">
            <?= htmlspecialchars($cat['title']) ?>
          </h3>
          <p class="text-xs mb-3 leading-relaxed line-clamp-2" style="color:#7A7788;">
            <?= htmlspecialchars(substr($cat['description'],0,90)) ?>…
          </p>
          <!-- Meta row -->
          <div class="flex items-center justify-between text-xs mb-4" style="color:#ADAAB8;">
            <span><?= number_format($cat['products_count']) ?>+ products</span>
            <span><?= $cat['pages'] ?> pages</span>
          </div>

          <!-- Action buttons -->
          <div class="pdf-card-actions">
            <a href="<?= $viewerHref ?>"
               class="btn-primary flex-1 justify-center py-2.5 rounded-xl text-xs">
              <?php if ($isRealPdf): ?>
              <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                      d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
              </svg>
              <?php else: ?>
              <svg class="w-3.5 h-3.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                      d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
              </svg>
              <?php endif; ?>
              <?= $viewerLabel ?>
            </a>
            <a href="<?= $base ?>/<?= $cat['pdf_url'] ?>"
               target="_blank" rel="noopener"
               class="btn-ghost py-2.5 px-3 rounded-xl" title="Open PDF in browser"
               style="border-color:<?= $cat['accent'] ?>44;color:<?= $cat['accent'] ?>;">
              <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                      d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"/>
              </svg>
            </a>
            <a href="<?= $base ?>/<?= $cat['pdf_url'] ?>"
               download
               class="btn-ghost py-2.5 px-3 rounded-xl" title="Download PDF">
              <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                      d="M12 10v6m0 0l-3-3m3 3l3-3M3 17v3a1 1 0 001 1h16a1 1 0 001-1v-3"/>
              </svg>
            </a>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>

  </div>
</section>

<!-- ═══════════════════════════════════════════
     HOW TO GET YOUR CATALOGUE
════════════════════════════════════════════ -->
<section class="section-spacing" style="background:#EDEAE3;border-top:1px solid rgba(0,0,0,0.06);">
  <div class="container-xl">
    <div class="text-center mb-14 reveal">
      <div class="section-badge mx-auto mb-6"><span class="dot"></span>Need Help?</div>
      <div class="section-gold-line mb-5"></div>
      <h2 class="text-3xl md:text-4xl font-display font-bold mb-4" style="color:#0E0B16;">
        Can't Find What You're Looking For?
      </h2>
      <p class="max-w-xl mx-auto text-sm leading-relaxed" style="color:#7A7788;">
        Our 2026 catalogues represent a curated selection. We source from 500+ global manufacturers.
        If you have a specific product in mind, our team will find and brand it for you.
      </p>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 stagger-children">
      <?php
      $helps = [
        ['icon'=>'M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z', 'title'=>'Request a Custom Catalogue', 'desc'=>'Tell us your product category and we\'ll build a bespoke catalogue tailored to your brand and budget.', 'cta'=>'Email Us', 'href'=>'mailto:sales@ramblerco.com'],
        ['icon'=>'M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z', 'title'=>'Talk to a Specialist', 'desc'=>'Our gifting specialists will walk you through our full range and help you find the perfect branded solution.', 'cta'=>'Call Now', 'href'=>'tel:+97470993232'],
        ['icon'=>'M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z', 'title'=>'Live Chat Support', 'desc'=>'Chat with our team in real-time for instant answers about products, pricing, and MOQ requirements.', 'cta'=>'Start Chat', 'href'=>'#'],
      ];
      foreach ($helps as $h): ?>
      <div class="glass-card p-7">
        <div class="service-icon mb-5">
          <svg class="w-5 h-5" style="color:#C42830;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="<?= $h['icon'] ?>"/>
          </svg>
        </div>
        <h3 class="font-semibold text-base mb-2" style="color:#0E0B16;"><?= $h['title'] ?></h3>
        <p class="text-sm leading-relaxed mb-5" style="color:#7A7788;"><?= $h['desc'] ?></p>
        <a href="<?= $h['href'] ?>" class="text-sm font-semibold transition-colors flex items-center gap-2"
           style="color:#C42830;"
           onmouseover="this.style.color='#0E0B16'" onmouseout="this.style.color='#C42830'">
          <?= $h['cta'] ?>
          <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"/>
          </svg>
        </a>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<?php include __DIR__ . '/includes/footer.php'; ?>

<!-- PDF.js for real-PDF book covers (loaded only if needed) -->
<?php if (count(array_filter($all_cats, fn($c) => ($c['viewer'] ?? '') === 'real-pdf')) > 0): ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.min.js"></script>
<?php endif; ?>

<!-- Spinner keyframe for real-cover loaders -->
<style>
@keyframes rcSpin { to { transform: rotate(360deg); } }
</style>

<!-- ── Catalog Page JS ── -->
<script>
// ── Filter ──────────────────────────────────
function filterCatalogs(btn, filter) {
  document.querySelectorAll('.filter-tab').forEach(t => t.classList.remove('active'));
  btn.classList.add('active');

  const cards = document.querySelectorAll('#catalog-grid .pdf-card');
  let visible = 0;
  cards.forEach(card => {
    const match = filter === 'all' || card.dataset.category === filter;
    card.style.transition = 'opacity .3s, transform .3s';
    if (match) {
      card.style.opacity   = '1';
      card.style.transform = 'scale(1)';
      card.style.display   = '';
      visible++;
    } else {
      card.style.opacity   = '0';
      card.style.transform = 'scale(.94)';
      setTimeout(() => { if(card.style.opacity === '0') card.style.display = 'none'; }, 300);
    }
  });
  const countEl = document.getElementById('catalog-count');
  if (countEl) countEl.textContent = visible + ' catalogue' + (visible !== 1 ? 's' : '');
}

// ── GSAP on catalog cards ───────────────────
document.addEventListener('DOMContentLoaded', () => {
  if (typeof gsap !== 'undefined' && typeof ScrollTrigger !== 'undefined') {
    gsap.registerPlugin(ScrollTrigger);

    // ── Grid cards — luxury back-ease stagger ──
    gsap.utils.toArray('#catalog-grid .pdf-card').forEach((card, i) => {
      gsap.fromTo(card,
        { opacity: 0, y: 55, scale: .93 },
        { opacity: 1, y: 0, scale: 1,
          duration: .88, delay: (i % 4) * .09,
          ease: 'back.out(1.4)',
          scrollTrigger: { trigger: card, start: 'top 90%' }
        }
      );
    });

    // ── Featured catalog — cinematic split reveal ──
    const feat = document.querySelector('.catalog-featured');
    if (feat && feat.children.length >= 2) {
      gsap.from(feat.children[0], {
        x: -70, opacity: 0, duration: 1.2, ease: 'expo.out',
        scrollTrigger: { trigger: feat, start: 'top 82%' }
      });
      gsap.from(feat.children[1], {
        x: 70, opacity: 0, duration: 1.2, ease: 'expo.out', delay: .12,
        scrollTrigger: { trigger: feat, start: 'top 82%' }
      });
    }

    // ── Brand trust strip fade-in ──
    const strip = document.querySelector('.catalog-brand-strip');
    if (strip) gsap.from(strip, { opacity: 0, y: 16, duration: .7, ease: 'power2.out', scrollTrigger: { trigger: strip, start: 'top 88%' } });
  }
});
</script>

<!-- ── Real PDF cover lazy-renderer ── -->
<script>
(function() {
  const canvases = document.querySelectorAll('.real-pdf-cover-canvas');
  if (!canvases.length || typeof pdfjsLib === 'undefined') return;

  pdfjsLib.GlobalWorkerOptions.workerSrc =
    'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.worker.min.js';

  const observer = new IntersectionObserver((entries) => {
    entries.forEach(async entry => {
      if (!entry.isIntersecting) return;
      observer.unobserve(entry.target);

      const canvas  = entry.target;
      const pdfUrl  = canvas.dataset.pdfUrl;
      const loaderId = canvas.dataset.loaderId;

      try {
        const pdf  = await pdfjsLib.getDocument({
          url            : pdfUrl,
          rangeChunkSize : 65536,
          disableAutoFetch: true,
        }).promise;

        const page      = await pdf.getPage(1);
        const vp1       = page.getViewport({ scale: 1 });

        // Scale to fill the cover container at 2× for crisp display
        const container = canvas.parentElement;
        const cw        = container.offsetWidth  || 180;
        const ch        = container.offsetHeight || 248;
        const scale     = Math.max(cw / vp1.width, ch / vp1.height) * (window.devicePixelRatio || 1);
        const viewport  = page.getViewport({ scale });

        canvas.width  = viewport.width;
        canvas.height = viewport.height;

        await page.render({ canvasContext: canvas.getContext('2d'), viewport }).promise;

        // Fade in canvas, fade out spinner
        canvas.style.opacity = '1';
        const loader = document.querySelector('.real-cover-loader[data-id="' + loaderId + '"]');
        if (loader) {
          loader.style.opacity = '0';
          setTimeout(() => loader.style.display = 'none', 450);
        }
      } catch (e) {
        console.warn('Cover render failed for', pdfUrl, e);
      }
    });
  }, { threshold: 0.01, rootMargin: '300px' });

  canvases.forEach(c => observer.observe(c));
})();
</script>
