/* ============================================
   RAMBLER QATAR — PREMIUM JS 2026
   Lenis + GSAP + VanillaTilt + Canvas
   ============================================ */

// ── Lenis Smooth Scroll ─────────────────────
let lenis;
if (typeof Lenis !== 'undefined') {
  lenis = new Lenis({
    duration:       1.3,
    easing:         t => Math.min(1, 1.001 - Math.pow(2, -10 * t)),
    smoothWheel:    true,
    wheelMultiplier:1.15,
    touchMultiplier:2,
    infinite:       false,
  });
  function raf(time) { lenis.raf(time); requestAnimationFrame(raf); }
  requestAnimationFrame(raf);
  // GSAP integration
  if (typeof ScrollTrigger !== 'undefined') {
    lenis.on('scroll', ScrollTrigger.update);
    gsap.ticker.add(time => lenis.raf(time * 1000));
    gsap.ticker.lagSmoothing(0);
  }
}

document.addEventListener('DOMContentLoaded', () => {

  // ── Preloader ──────────────────────────────
  const preloader = document.getElementById('preloader');
  if (preloader) {
    window.addEventListener('load', () => {
      setTimeout(() => preloader.classList.add('hidden'), 500);
    });
  }

  // ── Custom Cursor ──────────────────────────
  const cursor   = document.getElementById('cursor');
  const follower = document.getElementById('cursor-follower');
  if (cursor && follower && window.matchMedia('(pointer:fine)').matches) {
    let mx=0, my=0, fx=0, fy=0;
    document.addEventListener('mousemove', e => {
      mx = e.clientX; my = e.clientY;
      cursor.style.left = mx+'px'; cursor.style.top = my+'px';
    });
    (function af() {
      fx += (mx-fx)*.11; fy += (my-fy)*.11;
      follower.style.left = fx+'px'; follower.style.top = fy+'px';
      requestAnimationFrame(af);
    })();
    document.querySelectorAll('a,button,.catalog-card,.product-card,.bento-item,.filter-tab,.pdf-book-wrapper,.glass-card')
      .forEach(el => {
        el.addEventListener('mouseenter', () => document.body.classList.add('cursor-hover'));
        el.addEventListener('mouseleave', () => document.body.classList.remove('cursor-hover'));
      });
  }

  // ── Nav scroll ─────────────────────────────
  const navbar = document.getElementById('navbar');
  if (navbar) {
    const s = () => navbar.classList.toggle('scrolled', window.scrollY > 50);
    window.addEventListener('scroll', s, { passive:true }); s();
  }

  // ══════════════════════════════════════════
  //  HERO CANVAS — Brand Particle Network
  // ══════════════════════════════════════════
  const canvas = document.getElementById('hero-canvas');
  if (canvas) {
    const ctx = canvas.getContext('2d');
    let particles = [], mouse = { x:-9999, y:-9999 };
    const N=90, CONN=145, REPEL=110;
    const COLS=['224,53,64','196,40,48','66,104,212','58,95,196','139,26,34'];

    const resize = () => { canvas.width=innerWidth; canvas.height=innerHeight; };

    class P {
      constructor(){ this.init(); }
      init(){
        this.x  = Math.random()*canvas.width;
        this.y  = Math.random()*canvas.height;
        this.vx = (Math.random()-.5)*.4;
        this.vy = (Math.random()-.5)*.4;
        this.r  = Math.random()*1.5+.5;
        this.bOp= Math.random()*.45+.18;
        this.op = this.bOp;
        this.col= COLS[Math.floor(Math.random()*COLS.length)];
        this.ph = Math.random()*Math.PI*2;
        this.ps = .012+Math.random()*.01;
      }
      update(){
        this.ph += this.ps;
        this.op = this.bOp + Math.sin(this.ph)*.1;
        // repel from mouse
        const dx=this.x-mouse.x, dy=this.y-mouse.y;
        const d=Math.sqrt(dx*dx+dy*dy);
        if(d<REPEL){ const f=(REPEL-d)/REPEL; this.x+=dx/d*f*2.2; this.y+=dy/d*f*2.2; }
        this.x+=this.vx; this.y+=this.vy;
        if(this.x<-10) this.x=canvas.width+10;
        if(this.x>canvas.width+10) this.x=-10;
        if(this.y<-10) this.y=canvas.height+10;
        if(this.y>canvas.height+10) this.y=-10;
      }
      draw(){
        ctx.beginPath(); ctx.arc(this.x,this.y,this.r,0,Math.PI*2);
        ctx.fillStyle=`rgba(${this.col},${this.op})`; ctx.fill();
      }
    }

    const connect=()=>{
      for(let i=0;i<particles.length;i++){
        for(let j=i+1;j<particles.length;j++){
          const dx=particles[i].x-particles[j].x, dy=particles[i].y-particles[j].y;
          const d=Math.sqrt(dx*dx+dy*dy);
          if(d<CONN){
            const a=(1-d/CONN)*.2;
            const g=ctx.createLinearGradient(particles[i].x,particles[i].y,particles[j].x,particles[j].y);
            g.addColorStop(0,`rgba(${particles[i].col},${a})`);
            g.addColorStop(1,`rgba(${particles[j].col},${a})`);
            ctx.beginPath(); ctx.strokeStyle=g; ctx.lineWidth=.55;
            ctx.moveTo(particles[i].x,particles[i].y);
            ctx.lineTo(particles[j].x,particles[j].y); ctx.stroke();
          }
        }
      }
    };

    const animate=()=>{
      ctx.clearRect(0,0,canvas.width,canvas.height);
      particles.forEach(p=>{ p.update(); p.draw(); });
      connect(); requestAnimationFrame(animate);
    };

    const init=()=>{ resize(); particles=Array.from({length:N},()=>new P()); animate(); };
    window.addEventListener('resize',()=>{ resize(); particles.forEach(p=>p.init()); },{passive:true});

    const hero = document.querySelector('.hero-section');
    if(hero){
      hero.addEventListener('mousemove', e=>{ mouse.x=e.clientX; mouse.y=e.clientY; });
      hero.addEventListener('mouseleave',()=>{ mouse.x=-9999; mouse.y=-9999; });
    }
    init();
  }

  // ══════════════════════════════════════════
  //  GSAP ANIMATIONS
  // ══════════════════════════════════════════
  if(typeof gsap!=='undefined' && typeof ScrollTrigger!=='undefined'){
    gsap.registerPlugin(ScrollTrigger);

    // Generic reveals
    gsap.utils.toArray('.reveal').forEach(el=>{
      gsap.fromTo(el,{opacity:0,y:50},{
        opacity:1,y:0,duration:.9,ease:'power3.out',
        scrollTrigger:{trigger:el,start:'top 88%'}
      });
    });
    gsap.utils.toArray('.reveal-left').forEach(el=>{
      gsap.fromTo(el,{opacity:0,x:-50},{
        opacity:1,x:0,duration:.9,ease:'power3.out',
        scrollTrigger:{trigger:el,start:'top 88%'}
      });
    });
    gsap.utils.toArray('.reveal-right').forEach(el=>{
      gsap.fromTo(el,{opacity:0,x:50},{
        opacity:1,x:0,duration:.9,ease:'power3.out',
        scrollTrigger:{trigger:el,start:'top 88%'}
      });
    });

    // Stagger children
    gsap.utils.toArray('.stagger-children').forEach(p=>{
      gsap.fromTo(Array.from(p.children),{opacity:0,y:42},{
        opacity:1,y:0,duration:.75,stagger:.1,ease:'power3.out',
        scrollTrigger:{trigger:p,start:'top 85%'}
      });
    });

    // Bento
    gsap.utils.toArray('.bento-item').forEach((el,i)=>{
      gsap.fromTo(el,{opacity:0,scale:.9},{
        opacity:1,scale:1,duration:.75,delay:i*.08,ease:'power2.out',
        scrollTrigger:{trigger:el,start:'top 90%'}
      });
    });

    // PDF book cards
    gsap.utils.toArray('.pdf-card').forEach((el,i)=>{
      gsap.fromTo(el,{opacity:0,y:55,rotateX:8},{
        opacity:1,y:0,rotateX:0,duration:.95,delay:(i%4)*.1,ease:'power3.out',
        scrollTrigger:{trigger:el,start:'top 90%'}
      });
    });

    // Hero entrance timeline
    const tl = gsap.timeline({delay:.25});
    const hb = document.querySelector('.hero-badge');
    const ht = document.querySelector('.hero-title');
    const hs = document.querySelector('.hero-subtitle');
    const ha = document.querySelector('.hero-actions');
    const hc = document.querySelector('.hero-chips');
    if(hb) tl.fromTo(hb,{opacity:0,scale:.8},{opacity:1,scale:1,duration:.6,ease:'back.out(1.7)'});
    if(ht) tl.fromTo(ht,{opacity:0,y:65},{opacity:1,y:0,duration:1.15,ease:'power4.out'},'-=.2');
    if(hs) tl.fromTo(hs,{opacity:0,y:35},{opacity:1,y:0,duration:.9,ease:'power3.out'},'-=.5');
    if(ha) tl.fromTo(ha,{opacity:0,y:22},{opacity:1,y:0,duration:.8,ease:'power3.out'},'-=.4');
    if(hc) tl.fromTo(hc,{opacity:0},{opacity:1,duration:.7},'-=.3');

    // Process connector
    const pc = document.querySelector('.process-connector');
    if(pc) gsap.fromTo(pc,{scaleX:0,transformOrigin:'left center'},{
      scaleX:1,duration:1.6,ease:'power2.inOut',
      scrollTrigger:{trigger:pc,start:'top 80%'}
    });

    // Section line decorators
    gsap.utils.toArray('.section-line').forEach(el=>{
      gsap.fromTo(el,{scaleX:0,opacity:0},{
        scaleX:1,opacity:1,duration:1.2,ease:'power2.inOut',
        scrollTrigger:{trigger:el,start:'top 90%'}
      });
    });

    // Big number parallax
    gsap.utils.toArray('.display-number').forEach(el=>{
      gsap.to(el,{
        yPercent:-15,ease:'none',
        scrollTrigger:{trigger:el,start:'top bottom',end:'bottom top',scrub:1.5}
      });
    });

    // Cards stagger on catalog grid
    gsap.utils.toArray('#catalog-grid .pdf-card').forEach((card,i)=>{
      gsap.fromTo(card,{opacity:0,y:55,rotateX:6},{
        opacity:1,y:0,rotateX:0,duration:.88,delay:(i%4)*.1,ease:'power3.out',
        scrollTrigger:{trigger:card,start:'top 90%'}
      });
    });

    // ── Brand Partner Cards — luxury stagger reveal ──
    const brandGrid = document.querySelector('.brand-partner-grid');
    if(brandGrid){
      const brandCards = brandGrid.querySelectorAll('.brand-partner-card');
      gsap.fromTo(brandCards,
        { opacity:0, y:55, scale:.92 },
        {
          opacity:1, y:0, scale:1,
          duration:.8, stagger:.09,
          ease:'back.out(1.5)',
          scrollTrigger:{ trigger:brandGrid, start:'top 85%' }
        }
      );
    }

    // ── Hero Book Scroll Parallax ──
    const heroBook = document.querySelector('.hero-book-float');
    if(heroBook){
      gsap.to(heroBook, {
        y: -35, ease:'none',
        scrollTrigger:{
          trigger:'.hero-section', start:'top top',
          end:'bottom top', scrub:1.8
        }
      });
    }

    // ── Hero Ring Parallax (slow drift on scroll) ──
    gsap.to('.hero-ring-1', {
      yPercent:25, ease:'none',
      scrollTrigger:{ trigger:'.hero-section', start:'top top', end:'bottom top', scrub:2 }
    });
    gsap.to('.hero-ring-2', {
      yPercent:18, ease:'none',
      scrollTrigger:{ trigger:'.hero-section', start:'top top', end:'bottom top', scrub:2.5 }
    });

    // ── Luxury divider line draw-in ──
    gsap.utils.toArray('.luxury-divider').forEach(el=>{
      gsap.fromTo(el, { scaleX:0, opacity:0 }, {
        scaleX:1, opacity:.45, duration:1.4, ease:'power2.inOut',
        scrollTrigger:{ trigger:el, start:'top 90%' }
      });
    });

    // ── Why card gold line reveal ──
    gsap.utils.toArray('.why-card').forEach((el,i)=>{
      gsap.fromTo(el,
        { opacity:0, y:40 },
        { opacity:1, y:0, duration:.85, delay:i*.12, ease:'power3.out',
          scrollTrigger:{ trigger:el, start:'top 86%' }
        }
      );
    });
  }

  // ── Counter Animation ──────────────────────
  document.querySelectorAll('[data-counter]').forEach(el=>{
    const obs = new IntersectionObserver(entries=>{
      if(!entries[0].isIntersecting) return;
      const end=parseInt(el.dataset.counter,10), dur=2200;
      const step=end/(dur/16); let cur=0;
      const tick=()=>{ cur=Math.min(cur+step,end); el.textContent=Math.floor(cur).toLocaleString(); if(cur<end) requestAnimationFrame(tick); else el.textContent=end.toLocaleString(); };
      requestAnimationFrame(tick);
      obs.unobserve(el);
    },{threshold:.6});
    obs.observe(el);
  });

  // ── VanillaTilt on cards ──────────────────
  if(typeof VanillaTilt !== 'undefined'){
    VanillaTilt.init(document.querySelectorAll('.glass-card,.catalog-card,.testimonial-card,.why-card'), {
      max:6, speed:500, glare:true, 'max-glare':.08, perspective:1200, scale:1.02,
    });
    VanillaTilt.init(document.querySelectorAll('.pdf-book-wrapper'), {
      max:10, speed:400, glare:false, perspective:900,
    });
    // Brand partner cards — subtle 3D tilt
    VanillaTilt.init(document.querySelectorAll('.brand-partner-card'), {
      max:8, speed:600, glare:true, 'max-glare':.06, perspective:1000, scale:1.03,
    });
    // Product cards — gentle tilt for catalog detail page
    VanillaTilt.init(document.querySelectorAll('.product-card'), {
      max:5, speed:600, glare:true, 'max-glare':.05, perspective:1100, scale:1.02,
    });
  }

  // ── Magnetic buttons ──────────────────────
  document.querySelectorAll('.btn-primary, .btn-ghost').forEach(btn=>{
    btn.classList.add('btn-magnetic');
    btn.addEventListener('mousemove', e=>{
      const r  = btn.getBoundingClientRect();
      const x  = e.clientX - r.left - r.width/2;
      const y  = e.clientY - r.top  - r.height/2;
      btn.style.transform = `translate(${x*.18}px, ${y*.18}px)`;
    });
    btn.addEventListener('mouseleave', ()=>{ btn.style.transform=''; });
  });

  // ── Filter Tabs ────────────────────────────
  const ftabs    = document.querySelectorAll('.filter-tab[data-filter]');
  const ftargets = document.querySelectorAll('[data-category]');
  if(ftabs.length && ftargets.length){
    ftabs.forEach(tab=>{
      tab.addEventListener('click', e=>{
        e.preventDefault();
        ftabs.forEach(t=>t.classList.remove('active'));
        tab.classList.add('active');
        const f=tab.dataset.filter;
        ftargets.forEach(c=>{
          const show = f==='all' || c.dataset.category===f;
          c.style.transition='opacity .3s, transform .3s';
          if(show){ c.style.opacity='1'; c.style.transform='scale(1)'; c.style.display=''; }
          else { c.style.opacity='0'; c.style.transform='scale(.94)'; setTimeout(()=>{ if(c.style.opacity==='0') c.style.display='none'; },300); }
        });
      });
    });
  }

  // ── Smooth anchor scroll ──────────────────
  document.querySelectorAll('a[href^="#"]').forEach(a=>{
    a.addEventListener('click', e=>{
      const id=a.getAttribute('href'); if(id==='#') return;
      const target=document.querySelector(id);
      if(target){
        e.preventDefault();
        if(lenis) lenis.scrollTo(target,{offset:-80,duration:1.4});
        else window.scrollTo({top:target.offsetTop-80,behavior:'smooth'});
      }
    });
  });

  // ── Contact form ──────────────────────────
  const form=document.getElementById('contact-form');
  if(form){
    form.addEventListener('submit', e=>{
      e.preventDefault();
      const btn=form.querySelector('[type="submit"]');
      const orig=btn.innerHTML;
      btn.innerHTML='Sending…'; btn.disabled=true;
      setTimeout(()=>{
        btn.innerHTML='✓ Message Sent!'; btn.style.background='linear-gradient(135deg,#10B981,#059669)';
        setTimeout(()=>{ btn.innerHTML=orig; btn.style.background=''; btn.disabled=false; form.reset(); },3000);
      },1500);
    });
  }

  // ── Back to top ───────────────────────────
  window.addEventListener('scroll',()=>{
    const btn=document.getElementById('back-top');
    if(!btn) return;
    btn.style.opacity=window.scrollY>500?'1':'0';
    btn.style.pointerEvents=window.scrollY>500?'auto':'none';
  },{passive:true});

});
